package plugins.filenames.delemptydir;


import kernel.*;
import java.io.*;

import javax.swing.JOptionPane;


/**
 * Designed for RegexSR 1.0
 * 
 * @author Michel Deriaz 
 */
@SuppressWarnings("serial")
public class DelEmptyDir extends PluginFilenames {
  
  
  public DelEmptyDir() {
    setSummary("Deletes all empty directories and sub-directories in the current directory");
  }
  
  
  public void execute() {
    File dir = getDir();
    String[] oldFiles = getOldFiles(PluginFilenames.FILTER_DIR_REC);
    if (oldFiles == null) {
      JOptionPane.showMessageDialog(this, "No directories.", "Error", JOptionPane.ERROR_MESSAGE);
      return;
    }
    boolean stop;
    do {
      stop = true;
      for (String s : oldFiles) {
        if (new File(dir.toString() + '/' + s).delete() == true) stop = false;
      }
    }
    while (!stop);
  }  
}