package plugins.filenames.listmatches;


import kernel.*;
import java.awt.*;
import javax.swing.*;


/**
 * Designed for RegexSR 1.0
 * 
 * @author Michel Deriaz 
 */
@SuppressWarnings("serial")
public class ListMatches extends PluginFilenames {
  
  
  public ListMatches() {
    setSummary("Lists all matches");
    setDescription("Returns a list with all the filenames that match completely the expression.");
  }
  
  
  public void execute() {
    String[] oldFiles = getOldFiles(PluginFilenames.FILTER_NO);
    if (oldFiles == null) {
      JOptionPane.showMessageDialog(this, "No files.", "Error", JOptionPane.ERROR_MESSAGE);
      return;
    }
    StringBuilder sb = new StringBuilder();
    for (String file : oldFiles) {
      if (file.matches(getFlagsAsLiteral() + getSearch())) sb.append(file + '\n');
    }
    if (sb.length() == 0) JOptionPane.showMessageDialog(this, "No matches.", "Error", JOptionPane.ERROR_MESSAGE);
    else {
      JTextArea ta = new JTextArea(sb.toString());     
      ta.setForeground(Color.RED);
      ta.setEditable(false);
      ta.setMargin(new Insets(5, 5, 5, 5));
      JPanel p = new JPanel(new BorderLayout());
      p.add(new JScrollPane(ta), BorderLayout.CENTER);
      JDialog dialog = new JDialog(getOwner(), "Results", true);
      dialog.add(p, BorderLayout.CENTER);
      dialog.setSize(300, 300);
      dialog.setLocationRelativeTo(null);
      dialog.setVisible(true);
    }
  }
}