package plugins.filenames.modcase;


import kernel.*;
import javax.swing.*;
import java.util.regex.*;
import java.io.*;


/**
 * Designed for RegexSR 1.0
 * 
 * @author Michel Deriaz 
 */
@SuppressWarnings("serial")
public class ModCase extends PluginFilenames {
  
  
  public ModCase() {
    setSummary("Modifies the case of all the files and directories in the current directory and sub-directories");
  }
  
  
  public void execute() {
    File dir = getDir();
    String[] oldFiles = getOldFiles(PluginFilenames.FILTER_NO);
    if (oldFiles == null) {
      JOptionPane.showMessageDialog(this, "No files.", "Error", JOptionPane.ERROR_MESSAGE);
      return;
    }
    ModCaseDialog dialog = new ModCaseDialog(this);
    if (dialog.getChoice() == ModCaseDialog.CANCEL) return;
    if (dialog.isAllSelected()) {
      for (int i = 0; i < oldFiles.length; i++) {
        File fOld = new File(dir + "/" + oldFiles[i]);
        File fNew;
        if (dialog.getChoice() == ModCaseDialog.TO_LOWER_CASE) fNew = new File(dir + "/" + oldFiles[i].toLowerCase());
        else fNew = new File(dir + "/" + oldFiles[i].toUpperCase());
        fNew.getParentFile().mkdirs();
        fOld.renameTo(fNew);              
      }
    }
    else {
      try {
        String regex = getSearch();
        Pattern p = Pattern.compile(regex, getFlags());
        for (int i = 0; i < oldFiles.length; i++) {
          String of = oldFiles[i];
          Matcher m = p.matcher(of);
          if (m.find()) {
            int start = m.start();
            int end = m.end();
            String prefix, middle, suffix;
            prefix = of.substring(0, start);
            if (dialog.getChoice() == ModCaseDialog.TO_LOWER_CASE) {
              middle = of.substring(start, end).toLowerCase();
            }
            else {
              middle = of.substring(start, end).toUpperCase();
            }
            suffix = of.substring(end);
            File fOld = new File(dir + "/" + oldFiles[i]);
            File fNew = new File(dir + "/" + prefix + middle + suffix);
            fNew.getParentFile().mkdirs();
            fOld.renameTo(fNew);
          }
        }
      }
      catch(PatternSyntaxException e) {
        JOptionPane.showMessageDialog(this, "Error in regular expression.", "Error", JOptionPane.ERROR_MESSAGE);
      }
      catch(StringIndexOutOfBoundsException e) {
        JOptionPane.showMessageDialog(this, "Error in regular expression.", "Error", JOptionPane.ERROR_MESSAGE);
      }
    }
  }  
}