package plugins.filenames.modcase;


import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


/**
 * @author Michel Deriaz
 */
@SuppressWarnings("serial")
public class ModCaseDialog extends JDialog implements ActionListener {
  public static final int CANCEL = 0;
  public static final int TO_LOWER_CASE = 1;
  public static final int TO_UPPER_CASE = 2;
  
  private JButton butLower, butUpper;
  private JRadioButton rbAll, rbMatching; 
  private int choice = CANCEL;
  
  
  public ModCaseDialog(ModCase modCase) {
    super(modCase.getOwner(), "Modify case", true);
    JPanel panel = new JPanel(new BorderLayout());
    panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    
    JPanel panRB = new JPanel();
    panRB.setBorder(BorderFactory.createTitledBorder(" Apply to "));
    rbAll = new JRadioButton("all", true);
    panRB.add(rbAll);
    rbMatching = new JRadioButton("matching patterns", true);
    panRB.add(rbMatching);
    ButtonGroup aGroup = new ButtonGroup();
    aGroup.add(rbAll);
    aGroup.add(rbMatching);       
    panel.add(panRB, BorderLayout.NORTH);
    
    JPanel panButton = new JPanel(new GridLayout(1, 2, 10, 0));
    panButton.setBorder(BorderFactory.createEmptyBorder(20, 0, 10, 0));
    butLower = new JButton("To lower case");
    butLower.addActionListener(this);
    panButton.add(butLower);
    butUpper = new JButton("To upper case");
    butUpper.addActionListener(this);
    panButton.add(butUpper);
    panel.add(panButton, BorderLayout.SOUTH);
    
    add(panel);
    pack();
    setLocationRelativeTo(null);
    setVisible(true);
  }
  
  
  public int getChoice() {
    return choice;
  }
  
  
  public boolean isAllSelected() {
    return rbAll.isSelected();
  }
  
  
  public void actionPerformed(ActionEvent e) {
    if (e.getSource().equals(butLower)) choice = TO_LOWER_CASE;
    if (e.getSource().equals(butUpper)) choice = TO_UPPER_CASE;
    setVisible(false);
  }
}