package plugins.filenames.number;


import kernel.*;
import javax.swing.*;
import java.io.*;


/**
 * Designed for RegexSR 1.0
 * 
 * @author Michel Deriaz 
 */
@SuppressWarnings("serial")
public class Number extends PluginFilenames {
  
  
  public Number() {
    setSummary("Numbers the files");
    setDescription("<html><body>Only the files and directories in the current directory will be numbered.<br>Select the \"Reverse order\" checkbox to number in descending order.</body></html>");
  }
  
  
  public void execute() {
    File dir = getDir();
    String[] oldFiles = getOldFiles(PluginFilenames.FILTER_FILE_AND_DIR);
    if (oldFiles == null) {
      JOptionPane.showMessageDialog(this, "No files.", "Error", JOptionPane.ERROR_MESSAGE);
      return;
    }
    int start;
    try {
      start = Integer.parseInt(JOptionPane.showInputDialog("Starts at:"));
      if (start < 0) throw new NumberFormatException();
    }
    catch(NumberFormatException e) {
      return;
    }
    int nbDigits = ("" + (start-1+oldFiles.length)).length();
    for (int i = 0; i < oldFiles.length; i++) {
      int nbZeros = nbDigits-("" + (i+start)).length();
      String zeros = "";
      for (int j = 0; j < nbZeros; j++) zeros += "0";
      File fOld = new File(dir + "/" + oldFiles[i]);
      File fNew = new File(dir + "/" + zeros + (i+start) + "-" + oldFiles[i]);
      fNew.getParentFile().mkdirs();
      fOld.renameTo(fNew);      
    }
  }
}