package plugins.text.accents;


import kernel.*;


/**
 * Designed for RegexSR 1.0
 * 
 * @author Michel Deriaz 
 */
@SuppressWarnings("serial")
public class Accents extends PluginText {
  
  
  public Accents() {
    setSummary("Handles accents (to html, to ISO, remove accents...)");
    setDescription("Converts accentuated letters in html code, ISO code (and vice versa), or removes accents.");
  }
  
  
  public void execute() {
    InputDialog dialog = new InputDialog(this);
    if (dialog.getChoice() == InputDialog.A2H) setText(Tools.accentsToHtml(getText()));
    if (dialog.getChoice() == InputDialog.H2A) setText(Tools.htmlToAccents(getText()));
    if (dialog.getChoice() == InputDialog.A2I) setText(Tools.accentsToIso(getText()));
    if (dialog.getChoice() == InputDialog.I2A) setText(Tools.isoToAccents(getText()));
    if (dialog.getChoice() == InputDialog.RA) setText(Tools.removeAccents(getText()));
  }
}