package plugins.text.accents;


import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


/**
 * @author Michel Deriaz
 */
@SuppressWarnings("serial")
public class InputDialog extends JDialog implements ActionListener {
  public static final int A2H = 1; // Accents to HTML
  public static final int H2A = 2; // HTML to Accents
  public static final int A2I = 3; // Accents to ISO
  public static final int I2A = 4; // ISO to Accents
  public static final int RA = 5;  // Removes Accents
  
  private JButton butA2H, butH2A, butA2I, butI2A, butRA;
  private int choice = -1;
  
  
  public InputDialog(Accents accents) {
    super(accents.getOwner(), "Accents", true);
    
    JPanel panel = new JPanel(new GridLayout(3, 2, 10, 10));
    panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    
    butA2H = new JButton("Accents to HTML");
    butA2H.addActionListener(this);
    panel.add(butA2H);
    
    butH2A = new JButton("HTML to Accents");
    butH2A.addActionListener(this);
    panel.add(butH2A);
    
    butA2I = new JButton("Accents to ISO");
    butA2I.addActionListener(this);
    panel.add(butA2I);
    
    butI2A = new JButton("ISO to Accents");
    butI2A.addActionListener(this);
    panel.add(butI2A);
    
    butRA = new JButton("Remove Accents");
    butRA.addActionListener(this);
    panel.add(butRA);
    
    add(panel);
    pack();
    setLocationRelativeTo(null);
    setVisible(true);
  }
  
  
  public int getChoice() {
    return choice;
  }
  
  
  public void actionPerformed(ActionEvent e) {
    if (e.getSource().equals(butA2H)) choice = A2H;
    if (e.getSource().equals(butH2A)) choice = H2A;
    if (e.getSource().equals(butA2I)) choice = A2I;
    if (e.getSource().equals(butI2A)) choice = I2A;
    if (e.getSource().equals(butRA)) choice = RA;
    setVisible(false);
  }
}