package plugins.text.javacode;


import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


/**
 * @author Michel Deriaz
 */
@SuppressWarnings("serial")
public class InputDialog extends JDialog implements ActionListener {
  public static final int CLOSE = 0;
  public static final int IMPORT = 1;
  
  private JTextField tf;
  private JButton butImport, butClose;
  private int choice = -1;
  
  
  public InputDialog(JavaCode javaCode, String inJavaCode) {
    super(javaCode.getOwner(), "Java Code", true);
    
    Box box = Box.createVerticalBox();
    box.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    
    JPanel panTo = new JPanel(new BorderLayout());
    panTo.setBorder(BorderFactory.createTitledBorder("  To Java  "));
    JTextArea ta = new JTextArea(inJavaCode);     
    ta.setEditable(false);
    ta.setMargin(new Insets(5, 5, 5, 5));    
    panTo.add(new JScrollPane(ta), BorderLayout.CENTER);
    box.add(panTo);
    
    box.add(Box.createVerticalStrut(30));
    
    JPanel panFrom = new JPanel(new FlowLayout(FlowLayout.LEFT));
    panFrom.setBorder(BorderFactory.createTitledBorder("  From Java  "));
    tf = new JTextField(45);
    panFrom.add(tf);
    butImport = new JButton("Import");
    butImport.addActionListener(this);
    panFrom.add(butImport);
    box.add(panFrom);
    
    box.add(Box.createVerticalStrut(30));
    
    butClose = new JButton("Close");
    butClose.addActionListener(this);
    box.add(butClose);
    
    add(box);
    
    setSize(620, 350);
    setLocationRelativeTo(null);
    setVisible(true);
  }
  
  
  public int getChoice() {
    return choice;
  }
  
  
  public String getFromJava() {
    return tf.getText();
  }
  
  
  public void actionPerformed(ActionEvent e) {
    if (e.getSource().equals(butImport)) choice = IMPORT;
    if (e.getSource().equals(butClose)) choice = CLOSE;
    setVisible(false);
  }
}