package plugins.text.javacode;


import kernel.*;


/**
 * Designed for RegexSR 1.0
 * 
 * @author Michel Deriaz 
 */
@SuppressWarnings("serial")
public class JavaCode extends PluginText {
  
  
  public JavaCode() {
    setSummary("Transforms regular expressions into java code and vice versa");
    setDescription(readFile(getPluginsDir() + "/text/javacode/description.html"));
  }
  
  
  public void execute() {
    InputDialog dialog = new InputDialog(this, toJavaCode());
    if (dialog.getChoice() == InputDialog.IMPORT) fromJavaCode(dialog.getFromJava());
  }
  
  
  private String toJavaCode() {
    String result = "- Literal:\n";
    String regex = getSearch();
    if (isCANON_EQ()) result += "There is no literal form if the CANON_EQ flag is selected";
    else {
      result += getFlagsAsLiteral();
      
      // double every single backslash and put a backslash in front of each 
      // inverted comma
      result += regex.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\\"", "\\\\\\\"");
    }
    result += "\n\n- Compiled:\nPattern.compile(\"";
    
    // double every single backslash and put a backslash in front of each 
    // inverted comma
    result += regex.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\\"", "\\\\\\\"");
    result += "\"";
    String flags = "";
    flags += isCANON_EQ() ? "Pattern.CANON_EQ | " : "";
    flags += isCASE_INSENSITIVE() ? "Pattern.CASE_INSENSITIVE | " : "";
    flags += isCOMMENTS() ? "Pattern.COMMENTS | " : "";
    flags += isDOTALL() ? "Pattern.DOTALL | " : "";
    flags += isMULTILINE() ? "Pattern.MULTILINE | " : "";
    flags += isUNICODE_CASE() ? "Pattern.UNICODE_CASE | " : "";
    flags += isUNIX_LINES() ? "Pattern.UNIX_LINES | " : "";
    if (flags.length() > 0) result += ", " + flags.substring(0, flags.length()-3);
    result += ");\n";
    return result;
  }   
  
  
  private void fromJavaCode(String text) {
    if (text.startsWith("(?")) {
      String flags = text.substring(0, text.indexOf(")"));
      setCASE_INSENSITIVE(flags.indexOf("i") > -1);
      setCOMMENTS(flags.indexOf("x") > -1);
      setDOTALL(flags.indexOf("s") > -1);
      setMULTILINE(flags.indexOf("m") > -1);
      setUNICODE_CASE(flags.indexOf("u") > -1);
      setUNIX_LINES(flags.indexOf("d") > -1);
      text = text.substring(text.indexOf(")") + 1);
    }
    else if (text.startsWith("Pattern.compile(")) {
      setCANON_EQ(text.indexOf("Pattern.CANON_EQ") > -1);
      setCASE_INSENSITIVE(text.indexOf("Pattern.CASE_INSENSITIVE") > -1);
      setCOMMENTS(text.indexOf("Pattern.COMMENTS") > -1);      
      setDOTALL(text.indexOf("Pattern.DOTALL") > -1);
      setMULTILINE(text.indexOf("Pattern.MULTILINE") > -1);
      setUNICODE_CASE(text.indexOf("Pattern.UNICODE_CASE") > -1);
      setUNIX_LINES(text.indexOf("Pattern.UNIX_LINES") > -1);
      text = text.substring(text.indexOf("\"") + 1, text.lastIndexOf("\""));
    }
    else {
      setCANON_EQ(false);
      setCASE_INSENSITIVE(false);
      setCOMMENTS(false);      
      setDOTALL(false);
      setMULTILINE(false);
      setUNICODE_CASE(false);
      setUNIX_LINES(false);      
    }
    
    // replaces each pair of backslashes by a single one, and each backslash
    // followed by an inverted comma by an inverted comma
    text = text.replaceAll("\\\\\\\\", "\\\\").replaceAll("\\\\\\\"", "\\\"");
    setSearch(text);
  }         
}