package plugins.text.listmatches;


import kernel.*;
import java.util.regex.*;


/**
 * Designed for RegexSR 1.0
 * 
 * @author Michel Deriaz 
 */
@SuppressWarnings("serial")
public class ListMatches extends PluginText {
  
  
  public ListMatches() {
    setSummary("Lists all matches");
  }
  
  
  public void execute() {
    StringBuilder sb = new StringBuilder();
    Pattern p = Pattern.compile(getSearch(), getFlags());
    String text = getText();
    Matcher m = p.matcher(text);
    while (m.find()) {
      sb.append(text.substring(m.start(), m.end()));
      sb.append('\n');
    }
    setText(sb.length() > 0 ? sb.substring(0, sb.length()-1).toString() : "");
  }
}