package plugins.text.number;


import kernel.*;
import javax.swing.*;


/**
 * Designed for RegexSR 1.0
 * 
 * @author Michel Deriaz 
 */
@SuppressWarnings("serial")
public class Number extends PluginText {
  
  
  public Number() {
    setSummary("Numbers the lines");
  }
  
  
  public void execute() {
    String[] lines = getText().split("\\n");
    int start;
    try {
      start = Integer.parseInt(JOptionPane.showInputDialog("Starts at:"));
      if (start < 0) throw new NumberFormatException();
    }
    catch(NumberFormatException e) {
      return;
    }
    int nbDigits = ("" + (start-1+lines.length)).length();
    for (int i = 0; i < lines.length; i++) {
      int nbZeros = nbDigits-("" + (i+start)).length();
      String zeros = "";
      for (int j = 0; j < nbZeros; j++) zeros += "0";
      lines[i] = zeros + (i+start) + "-" + lines[i];
    }
    String result = "";
    for (int i = 0; i < lines.length; i++) {
      result += lines[i];
      if (i < lines.length-1) result += "\n";
    }
    setText(result);
  }
}