package plugins.text.paragraph;


import kernel.*;


/**
 * Designed for RegexSR 1.0
 * 
 * @author Michel Deriaz 
 */
@SuppressWarnings("serial")
public class Paragraph extends PluginText {
  
  
  public Paragraph() {
    setSummary("Removes all \\n characters in paragraphs");
    setDescription(readFile(getPluginsDir() + "/text/paragraph/description.html"));
  }
  
  
  public void execute() {
    if (getSelectionEnd() - getSelectionStart() == 0) {
      replaceAll(" +\\n", "\n");
      replaceAll("(?<=.)\\n(?=.)", " ");
    }
    else {
      String replacement = getSelectedText()
      .replaceAll(" +\\n", "\n")
      .replaceAll("(?<=.)\\n(?=.)", " ");
      replace(getSelectionStart(), getSelectionEnd(), replacement);
    }
  } 
}