package plugins.text.reordercolumns;


import kernel.*;
import javax.swing.*;


/**
 * Designed for RegexSR 1.0
 * 
 * @author Michel Deriaz 
 */
@SuppressWarnings("serial")
public class ReorderColumns extends PluginText {
  
  
  public ReorderColumns() {
    setSummary("Reorders columns of data sepatated by the \\t character");
    setDescription("If a column number is missing, the column will be suppressed. If a column number appears twice, the column will be copied.");
  }
  
  
  public void execute() {
    String text = getText();
    int nb = countColumns(text);
    if (nb == -1) {
      JOptionPane.showMessageDialog(null, "Text is not correctly formatted.", "Error", JOptionPane.ERROR_MESSAGE);
      return;
    }
    if (nb == 1)  {
      JOptionPane.showMessageDialog(null, "There is only one column.", "Error", JOptionPane.ERROR_MESSAGE);
      return;
    }
    StringBuilder defaultPattern = new StringBuilder("1");
    for (int i = 2; i <= nb; i++) defaultPattern.append("-" + i);
    String pattern = JOptionPane.showInputDialog("New order:", defaultPattern);
    if (pattern == null) return;
    int[] order;
    try {
      String[] numbers = pattern.split("-");
      order = new int[numbers.length];
      for (int i = 0; i < numbers.length; i++) {
        order[i] = Integer.parseInt(numbers[i]);
        if (order[i] < 1 || order[i] > nb) throw new NumberFormatException();
      }
    }
    catch (NumberFormatException e) {
      JOptionPane.showMessageDialog(this, "Incorrect numbers.", "Error", JOptionPane.ERROR_MESSAGE);
      return;
    }
    
    // at this point we are sure that the text is correctly formatted and that 
    // the numbers in the order table are correct
    StringBuilder result = new StringBuilder();
    String[] lines = text.split("\\n");
    for (int i = 0; i < lines.length; i++) {
      String[] items = lines[i].split("\\t");
      for (int j = 0; j < order.length; j++) {
        result.append(items[order[j]-1]);
        if (j < order.length-1) result.append('\t');
      }  
      if (i < lines.length-1) result.append('\n');
    }
    setText(result.toString());
  }
  
  
  /**
   * @param text the text
   * @return the number of columns or -1 if not all the lines have the same 
   * number of columns
   */
  private int countColumns(String text) {
    int nb = -1;
    if (text == null || text.equals("")) return -1;
    String[] lines = text.split("\n");
    nb = lines[0].split("\t").length;
    for (int i = 1; i < lines.length; i++) {
      if (lines[i].split("\t").length != nb) return -1;
    }
    return nb;
  }
}