package plugins.text.replaceinfiles;


import kernel.*;
import java.util.*;
import java.util.regex.*;
import java.io.*;
import javax.swing.*;


/**
 * Designed for RegexSR 1.0
 * 
 * @author Michel Deriaz 
 */
@SuppressWarnings("serial")
public class ReplaceInFiles extends PluginText {
  
  
  public ReplaceInFiles() {
    setSummary("Replacements in files");
    setDescription("<html><body>Lets you select a directory and then uses the current values (search and replace fields, flags) to search and replace in all the files in the selected directory and its sub-directories.<br>Note that the modifications done on the files can not be canceled afterwards.</body></html>");
  }
  
  
  public void execute() {
    File dir = chooseDir();
    if (dir == null) return;
    ArrayList<File> allFiles = new ArrayList<File>();
    Tools.getFilesRec(allFiles, dir, false);
    int returnVal = JOptionPane.showConfirmDialog(this, "" + allFiles.size() + " files will be treated. Continue?", "Select an option", JOptionPane.YES_NO_OPTION);
    if (returnVal != JOptionPane.YES_OPTION) return;
    try {
      Pattern p = Pattern.compile(getSearch(), getFlags());
      for (File f : allFiles) {
        String text = Tools.readFile(f.toString());
        Matcher m = p.matcher(text);
        Tools.writeFile(f.toString(), m.replaceAll(getReplace()));
      }
    }
    catch(PatternSyntaxException e) {
      JOptionPane.showMessageDialog(this, "Error in regular expression.", "Error", JOptionPane.ERROR_MESSAGE);
    }
    catch(StringIndexOutOfBoundsException e) {
      JOptionPane.showMessageDialog(this, "Error in regular expression.", "Error", JOptionPane.ERROR_MESSAGE);
    }
  }
  
  
  private File chooseDir() {
    JFileChooser chooser = new JFileChooser("");
    chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);  
    chooser.setFileFilter(new javax.swing.filechooser.FileFilter() {
      public boolean accept(File f) {
        return true;
      }
      public String getDescription() {
        return "Directories";
      }
    });    
    int returnVal = chooser.showOpenDialog(this);
    if (returnVal == JFileChooser.APPROVE_OPTION) {
      File dir = chooser.getSelectedFile();
      if (dir.isDirectory()) return dir; // checks also that the dir exists
    }
    return null;
  }
}