package plugins.text.sort;


import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


/**
 * @author Michel Deriaz
 */
@SuppressWarnings("serial")
public class InputDialog extends JDialog implements ActionListener {
  public static final int CANCEL = 0;
  public static final int OK = 1;
  
  private JCheckBox cbReverseOrder, cbCaseInsensitive;
  private JButton butOK, butCancel;
  private int choice = -1;
  
  
  public InputDialog(Sort sort) {
    super(sort.getOwner(), "Sort", true);
    JPanel panel = new JPanel(new GridLayout(4, 1));
    panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    
    JPanel p = new JPanel(new FlowLayout(FlowLayout.LEFT));
    cbReverseOrder = new JCheckBox("Reverse order");
    p.add(cbReverseOrder);
    panel.add(p);
    
    p = new JPanel(new FlowLayout(FlowLayout.LEFT));
    cbCaseInsensitive = new JCheckBox("Case insensitive");
    p.add(cbCaseInsensitive);
    panel.add(p);
    
    panel.add(new Container());
    
    p = new JPanel(new GridLayout(1, 2, 10, 0));
    butOK = new JButton("OK");
    butOK.addActionListener(this);
    p.add(butOK);
    butCancel = new JButton("Cancel");
    butCancel.addActionListener(this);
    p.add(butCancel);
    panel.add(p);
    
    add(panel);
    pack();
    setLocationRelativeTo(null);
    butOK.requestFocus();
    setVisible(true);
  }
  
  
  public int getChoice() {
    return choice;
  }
  
  
  public boolean isReverseOrderSelected() {
    return cbReverseOrder.isSelected();
  }
  
  
  public boolean isCaseInsensitiveSelected() {
    return cbCaseInsensitive.isSelected();
  }
  
  
  public void actionPerformed(ActionEvent e) {
    if (e.getSource().equals(butOK)) choice = InputDialog.OK;
    if (e.getSource().equals(butCancel)) choice = InputDialog.CANCEL;
    setVisible(false);
  }   
}
